local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"



local desblat_badge = Class(Widget, function(self, inst)
	Widget._ctor(self, "desblat_badge")
	self.owner = inst

    self:SetPosition(0,0,0)

    self.active = true

    self.drops = {}

    self.blood = ""
    self.active = true

    self.anim = self:AddChild(UIAnim())
	
	
	self.injurename = " "

	self.arrow = self.anim:AddChild(UIAnim())
	self.arrow:GetAnimState():SetBank("sanity_arrow")
	self.arrow:GetAnimState():SetBuild("sanity_arrow")
	self.arrow:GetAnimState():PlayAnimation("neutral")
	self.arrow:SetClickable(false)

    self.underNumber = self:AddChild(Widget("undernumber"))

    self.num = self:AddChild(Text(BODYTEXTFONT, 33))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(5, 0, 0)
	
	self.num:SetClickable(false)
	
	
    	self.num:Show()
--	self.num:GetAnimState():SetMultColour(0.5,.5,1,0.7)

	self:StartUpdating()
end)

function desblat_badge:UpdateMeter()
	---self.anim:GetAnimState():SetPercent("anim", self.blood/200)
end



function desblat_badge:SetPercent(val, max, penaltypercent)
	---Badge.SetPercent(self, val, max)
--	self.anim:GetAnimState():SetPercent("anim", self.blood/200)
	
end	





function desblat_badge:Activate()
	self.animTask = self.owner:DoPeriodicTask(.5, function() self:UpdateMeter() end)
end

function desblat_badge:Deactivate()
	if self.animTask then
		self.animTask:Cancel()
		self.animTask = nil
	end
	self.anim:GetAnimState():PlayAnimation("close")
	self.owner.SoundEmitter:PlaySound("dontstarve_DLC001/common/HUD_wet_close")
	
end

function desblat_badge:OnGainFocus()
	desblat_badge._base:OnGainFocus(self)
end

function desblat_badge:OnLoseFocus()
	desblat_badge._base:OnLoseFocus(self)
end

function desblat_badge:UpdateArrowAnim()
end

function desblat_badge:OnUpdate(dt)
    self.blood = self.owner.components.playercontroller_3.thingtocraft
	
	self.num:SetString("Craft: "..(self.blood).." ?.")
	
end


return desblat_badge